/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.number;

import java.math.BigDecimal;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.number.BigDecimalCloseTo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalCloseToTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        BigDecimal irrelevant = new BigDecimal("0.01");
        return BigDecimalCloseTo.closeTo((BigDecimal)irrelevant, (BigDecimal)irrelevant);
    }

    public void testEvaluatesToTrueIfArgumentIsEqualToABigDecimalWithinSomeError() {
        Matcher p = BigDecimalCloseTo.closeTo((BigDecimal)new BigDecimal("1.0"), (BigDecimal)new BigDecimal("0.5"));
        BigDecimalCloseToTest.assertTrue((boolean)p.matches((Object)new BigDecimal("1.0")));
        BigDecimalCloseToTest.assertTrue((boolean)p.matches((Object)new BigDecimal("0.5")));
        BigDecimalCloseToTest.assertTrue((boolean)p.matches((Object)new BigDecimal("1.5")));
        BigDecimalCloseToTest.assertDoesNotMatch("too large", p, new BigDecimal("2.0"));
        BigDecimalCloseToTest.assertMismatchDescription("<2.0> differed by <0.5>", p, new BigDecimal("2.0"));
        BigDecimalCloseToTest.assertDoesNotMatch("number too small", p, new BigDecimal("0.0"));
        BigDecimalCloseToTest.assertMismatchDescription("<0.0> differed by <0.5>", p, new BigDecimal("0.0"));
    }

    public void testEvaluatesToTrueIfArgumentHasDifferentScale() {
        Matcher p = BigDecimalCloseTo.closeTo((BigDecimal)new BigDecimal("1.0"), (BigDecimal)new BigDecimal("0.5"));
        BigDecimalCloseToTest.assertTrue((boolean)p.matches((Object)new BigDecimal("1.000000")));
        BigDecimalCloseToTest.assertTrue((boolean)p.matches((Object)new BigDecimal("0.500000")));
        BigDecimalCloseToTest.assertTrue((boolean)p.matches((Object)new BigDecimal("1.500000")));
        BigDecimalCloseToTest.assertDoesNotMatch("too large", p, new BigDecimal("2.000000"));
        BigDecimalCloseToTest.assertMismatchDescription("<2.000000> differed by <0.5>", p, new BigDecimal("2.000000"));
        BigDecimalCloseToTest.assertDoesNotMatch("number too small", p, new BigDecimal("0.000000"));
        BigDecimalCloseToTest.assertMismatchDescription("<0.000000> differed by <0.5>", p, new BigDecimal("0.000000"));
    }
}

